/*
 *  This sketch sends data via HTTP GET requests to data.sparkfun.com service.
 *
 *  You need to get streamId and privateKey at data.sparkfun.com and paste them
 *  below. Or just customize this script to talk to other HTTP servers.
 *
 */

 
 /* RAF
  *  Ajouter des paramétres pour gérer l'IP distante
  *  gerer les reconnexion en cas de perte
  *  Gerer les perte de wifi
  */
 
 

#include <ESP8266WiFi.h>
#include <WiFiUdp.h>
const char* ssid     = "xxxxxxxxxxx";
const char* password = "xxxxxxxxxx";

const char* host = "192.168.0.49";
const int httpPort = 23;
WiFiUDP udp;
WiFiUDP udp2;
IPAddress debugadr(192, 168, 0, 35);

  WiFiClient client;
void setup() {
  Serial.begin(115200,SERIAL_7E1);
  delay(10);

  // We start by connecting to a WiFi network

  Serial.println();
  Serial.println();
  Serial.print("Connecting to ");
  Serial.println(ssid);
  
  WiFi.begin(ssid, password);
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");  
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
  Serial.print("connecting to ");
  Serial.println(host);
  
  delay(2000);  
  // Use WiFiClient class to create TCP connections
  //WiFiClient client;
  //const int httpPort = 80;
  if (!client.connect(host, httpPort)) {
    Serial.println("connection failed");
    //return;
  }else Serial.println("connection OK");
 
  
}



void loop() {
// This will send the request to the server

  if(Serial.available()){

     String sline =Serial.readStringUntil('\n');
//     String sline =Serial.readStringUntil('m');
     size_t lon = sline.length();
     char sbuf[lon+2];
     sline.toCharArray(sbuf, lon+1); 
     sbuf[lon]=0x0A;
     lon++;
    
    client.write(sbuf, lon);


    udp.beginPacket(debugadr, 1111); //udp requests are to port 123
    //udp.write(sbuf, len);
    udp.write(sbuf, lon);
    udp.endPacket();
        //delay(1);
  }
 // delay(10);
  
  // Read all the lines of the reply from server and print them to Serial
  while(client.available()){
    String line = client.readStringUntil('\n');
    line += '\n';
     Serial.print(line);
     udp2.beginPacket(debugadr, 1112); //udp requests are to port 123
     udp2.print(line);
     udp2.endPacket();
  }
  
//  Serial.println();
//  Serial.println("closing connection");
}

