/* 
  Wifi Interface pour Automate Millenium / Zelio for esp8266

  Copyright (c) 2015 C.Euvrard. All rights reserved.
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
*/
#include <stdio.h>
#include <ESP8266WiFi.h>
#include <WiFiUdp.h>
#include <ESP8266WebServer.h>

//how many clients should be able to telnet to this ESP8266
#define MAX_SRV_CLIENTS 5
const char* ssid = "xxxxxxxxx";
const char* password = "xxxxxxxxx";

ESP8266WebServer webserver(80);

WiFiServer server(23); // Serveur Telnet
WiFiClient serverClients[MAX_SRV_CLIENTS];
WiFiUDP udp;
IPAddress debugadr(192, 168, 0, 35);

// transforme un Char HEX en Int
int chartoint(char val)  {return (val >64 ? val - 55 : val - 48);}

// Tansforme un Iint (0-16) en un Char HEX
char inttohex(int val)  {return (val > 9 ? val + 55 : val + 48);}

//Convertie un Int (val) en chaine Hexa (bufout) len = Nb de char de la conversion 
void convertToHex(char* bufout,int Val, int len)
{   for (int i=len; i > 0; i--)bufout[len-i] = inttohex(( (0x0F << 4*(i-1)) & Val) >> (4*(i-1)));  
   bufout[len] ='\0';}

//Convertie 2 char HEX en int
int convertToInt(char upper,char lower)  { return ((chartoint(upper)<<4)+chartoint(lower));}

// Envoie une trame UDP sur un PC pour la visualiser avec  Wireshark
//Si len = 0 on cherche le \0 pour trouver la longueur
void DebugUdp (int port, char* buff, int len){
     udp.beginPacket(debugadr, port); //udp requests are to port 123
     if (len == 0)udp.write(buff, strlen(buff));
        else udp.write(buff, len);
     udp.endPacket(); 
}

// Calcul du checksun d'une trame Modbus de l'automante
int cksum(char* buff,int lon){
  char cal = 0;
  for (int i=1;i<lon;i+=2) cal += convertToInt(buff[i],buff[i+1]);
  cal = (~cal)+2;
  return (cal);
}

// Permet de calculer le cksum d'une trame de l'envoier a l'automate
// de recuperer la trame de réponse et de verifier son Cksum
String SendReceive(String ibuf){
  char buft[40],str[5];
  String sline;
  ibuf.toCharArray(buft,30)  ;
  convertToHex(str,cksum (buft,ibuf.length()), 2);
  ibuf += String(str);
  ibuf += "\r\n";
  Serial.print(ibuf);
  delay(500);
  if(Serial.available()) sline=Serial.readStringUntil('\n');
  sline.toCharArray(buft,30); 
  //DebugUdp (1182,buft, 0);
  int   len = sline.length();
   if ( cksum (buft,(strlen(buft)-3)) == convertToInt(buft[len-3],buft[len-2]))return(sline);
   else return("ERREUR");
}

// Transforme en int la chaine de retour de lecture d'un bloc
int decodeTrame(String line){
  int  ret = 256 * convertToInt(line.charAt(7),line.charAt(8));
   ret += convertToInt(line.charAt(9),line.charAt(10));
   return (ret);
}

//Transforme une chaine de bit en string
int bitToInt(String line){
  int ret = 0;
  for (int i = 0; i < line.length(); i++) {
    ret = ret << 1;
    if ( line.charAt(i) == '1') ret++;
  }
  return ret;
}

// page Menu
void handleRoot() {
  String message;
  message =  "Serveur de  communication avec un Automate Millemium ou Zeliot via les blocs SLIn et SLOut/n";
  message += "Commande : \n";
  message += "slin?adr=aa&val=vvvvv   avec aa=adresse du bloc (1-24) et vvvvv= valeur a ecrire (0-65535)  \n";
  message += "slinbit?aa=bit&bb=1&8=0&12=1&15=0   avec aa=adresse du bloc (1-16) , bb= N° du bit (0-15) et v= O ou 1   \n";
  message += "slout?adr=aa    avec aa=adresse du bloc (1-24)\n";
  message += "trame?1=:01030000FF100A envoie une trame en ajoutant le Cksum\n";
  webserver.send(200, "text/plain", message);
}

// Routine d'envoie de trame: Prend la chaine ascii du 1er paramétre ajoute le Check sum et la fin chaine
// L'envoie a l'automate et renvoie la chaine de réponse
void handleTrame() {
  String message;
  message = SendReceive( webserver.arg(0));
  webserver.send(200, "text/plain", message);
}

// Page Write Bloc FDB SLIn
//Permet d'écrire une entrée (16 bits) d'un bloc SLIn 
void handleWrite() {
  String sline;
  String sbuf;
  String message;
  if(webserver.args() == 2){  
    int addr = webserver.arg(0).toInt();
    unsigned int val = webserver.arg(1).toInt();
       if ((addr <1 || addr > 24)||(webserver.arg(1).length()> 5)){ //||( webserver.argName(0)!= "adr" )||( webserver.argName(1)!= "var" )){
      webserver.send(200, "text/plain", "Erreur Argument \n slin?adr=11&val=12345\n");
      return;
    }
    sbuf = ":01100000FF";
    char str[9];
    convertToHex(str,addr-1, 2);
    sbuf += String(str); 
    sbuf += "02";
    convertToHex(str,val, 4);
    sbuf += String(str);
    message = SendReceive( sbuf);
    webserver.send(200, "text/plain", message);
  }
  webserver.send(200, "text/plain", "Erreur Argument \n slin?adr=11&val=12345\n");
}

// Page Write Bloc FDB SLIn
//Permet d'écrire un  bit dans un bloc SLIn 
void handleWriteBit() {
 String sline;
 String sbuf;
 String message;
  if((webserver.args() > 1)&& (webserver.arg(0) == "bit")) {
    int addr = webserver.argName(0).toInt();
    unsigned int decal = webserver.arg(0).toInt();
    if ((addr <1 || addr > 24)||(webserver.arg(0).length()> 5)){
      webserver.send(200, "text/plain", "Erreur Argument \n slin?11=12345\n");
      return;
    }
    int val;
    sbuf = ":01030000FF";
    char str[9];
    convertToHex(str,addr-1, 2);
    sbuf += String(str); 
    sbuf += "02";
    message = SendReceive( sbuf);
    if (message != "ERREUR"){
      val = decodeTrame(message);
    }
    for (uint8_t i=1; i<webserver.args(); i++){
      int mask = 1 << webserver.argName(i).toInt();   // 0x0008
      if (webserver.arg(i)=="1") val |=  mask;
        else val &= ~mask;
    } 
    sbuf = ":01100000FF";
    convertToHex(str,addr-1, 2);
    sbuf += String(str); 
    sbuf += "02";
    convertToHex(str,val, 4);
    sbuf += String(str);
    message = SendReceive( sbuf);
    webserver.send(200, "text/plain", message);
  }
  webserver.send(200, "text/plain", "Erreur Argument \n slinbit?aa=bit&bb=1&8=0&12=1&15=0   avec aa=adresse du bloc (1-24) , bb= N° du bit (0-15) et v= O ou 1   \n"); 
}

// Page Read Bloc FDB SLOut
//Permet de lire une Sortie (16 bits) d'un bloc SLOut 
void handleRead() {
 String message, sbuf;
 if(webserver.args() == 1){
    int addr = webserver.arg(0).toInt();
    if ((addr <1 || addr > 48)||(webserver.argName(0)!= "adr")){
      webserver.send(200, "text/plain", "Erreur Argument \n slout?adr=11\n");
      return;
    }
    //if ( addr > 24)addr -=24;
    sbuf = ":01030000FF";
    char str[9];
    convertToHex(str,addr-1, 2);
    sbuf += String(str); 
    sbuf += "02";
    message = String(sbuf);
    message += " ";
    message = SendReceive( sbuf);
    if (message != "ERREUR"){
      int val = decodeTrame(message);
      message = "Valeur_Ret  = ";
      message += val;
      message += "\n";
    }
    webserver.send(200, "text/plain", message); 
  }
  webserver.send(200, "text/plain", "Erreur Argument \n slout?adr=11\n"); 
}

// Page pour lancer des tests
void handleTest(){
  String message = " val In = ";
  int ret;
  unsigned int val = 43690;  //0xAAAA
  char buf[6];
  convertToHex(buf,val, 4);
  message += String(buf);
  for (uint8_t i=1; i<webserver.args(); i++){
      int mask = 1 << webserver.argName(i).toInt();   // 0x0008
      if (webserver.arg(i)=="1") val |=  mask;
        else val &= ~mask;
  } 
  message += " val out = ";
  convertToHex(buf,val, 4);
  message += String(buf);
  webserver.send(200, "text/plain", message);
}

// page 404 Not Found
void handleNotFound(){
  String message = "File Not Found\n\n";
  message += "URI: ";
  message += webserver.uri();
  message += "\nMethod: ";
  message += (webserver.method() == HTTP_GET)?"GET":"POST";
  message += "\nArguments: ";
  message += webserver.args();
  message += "\n";
  for (uint8_t i=0; i<webserver.args(); i++){
    message += " " + webserver.argName(i) + ": " + webserver.arg(i) + "\n";
  }
  webserver.send(404, "text/plain", message);
}

//demarrage
void setup() {
  Serial.begin(115200,SERIAL_7E1);
  WiFi.begin(ssid, password);
 // Serial.print("\nConnecting to "); Serial.println(ssid);
  uint8_t i = 0;
  while (WiFi.status() != WL_CONNECTED && i++ < 20) delay(500);
  if(i == 21){
 //   Serial.print("Could not connect to"); Serial.println(ssid);
    while(1) delay(500);
  }
  // lancement serveur Telnet
  server.begin();
  server.setNoDelay(true);

  //Lancement serveur Web
  webserver.on("/", handleRoot);
  webserver.on("/menu", handleRoot);
  webserver.on("/slout", handleRead);
  webserver.on("/slin", handleWrite);
  webserver.on("/trame", handleTrame);
  webserver.on("/slinbit", handleWriteBit);
  webserver.on("/test", handleTest);
  webserver.on("/inline", [](){
    webserver.send(200, "text/plain", "this works as well");
  });
  webserver.onNotFound(handleNotFound);
  webserver.begin();
  
 // Serial.print("Ready! Use 'telnet ");
 // Serial.print(WiFi.localIP());
 // Serial.println(" 23' to connect");
}

//Boucle sans fin
void loop() {
  uint8_t i;
  webserver.handleClient();  // serveur Web
  //check if there are any new clients serveur Telnet
  if (server.hasClient()){
    for(i = 0; i < MAX_SRV_CLIENTS; i++){
      //find free/disconnected spot
      if (!serverClients[i] || !serverClients[i].connected()){
        if(serverClients[i]) serverClients[i].stop();
        serverClients[i] = server.available();
//        Serial.print("New client: "); Serial.print(i);
        continue;
      }
    }
    //no free/disconnected spot so reject
    WiFiClient serverClient = server.available();
    serverClient.stop();
  }
  //check clients for data Client Telenet
  for(i = 0; i < MAX_SRV_CLIENTS; i++){
    if (serverClients[i] && serverClients[i].connected()){
      if(serverClients[i].available()){
        //get data from the telnet client and push it to the UART
        while(serverClients[i].available()) Serial.write(serverClients[i].read());
      }
    }
  }
  //check UART for data pour client telenet
  if(Serial.available()){
     String sline =Serial.readStringUntil('\n');
     size_t len = sline.length();
     char sbuf[len+2];
     sline.toCharArray(sbuf, len+1); 
     sbuf[len]=0x0A;
     len++;
     for(i = 0; i < MAX_SRV_CLIENTS; i++){
        if (serverClients[i] && serverClients[i].connected()){
          serverClients[i].write(sbuf, len);
    // DebugUdp (1122, sbuf, len);   

        }
     }
  }
}
